/*
 * Decompiled with CFR 0.152.
 */
package com.leospa.main;

import com.leospa.clients.SerialClient;
import com.leospa.main.Util;
import com.leospa.properties.ConfigPropertiesFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Timer;

public class MassageTimer {
    Timer timer;
    int time_in_sec = 0;
    int count = 0;
    Time previousTime = null;
    Time nextTime = null;
    Time timerStart = null;
    Time relayOnTime = null;
    Time relayOffTime = null;
    Time stopTimer = null;
    boolean realyOn = true;
    boolean realyOff = true;
    boolean timerClose = true;

    public MassageTimer(final int max_time, final String solarium_id, final int preTime, int afterTime) {
        this.time_in_sec = max_time;
        this.count = this.time_in_sec - 1;
        this.timerStart = new Time(MassageTimer.addSecondToCurrentTime(0).getTime());
        this.nextTime = new Time(MassageTimer.addSecondToCurrentTime(1).getTime());
        this.relayOnTime = new Time(MassageTimer.addSecondToCurrentTime(preTime).getTime());
        this.relayOffTime = new Time(MassageTimer.addSecondToCurrentTime(max_time - afterTime).getTime());
        this.stopTimer = new Time(MassageTimer.addSecondToCurrentTime(max_time).getTime());
        if (ConfigPropertiesFile.DEBUG_MODE_ON) {
            System.out.println("Timer Start: " + this.timerStart.toString());
            System.out.println("Relay On Time time: " + this.relayOnTime.toString());
            System.out.println("Relay Off Time time: " + this.relayOffTime.toString());
            System.out.println("Timer Stop: " + this.stopTimer.toString());
        }
        if (ConfigPropertiesFile.DEBUG_MODE_ON) {
            System.out.println("Solarium ID Booked===Timer Start" + max_time);
        }
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int starting_time = max_time - preTime;
                if ((MassageTimer.addSecondToCurrentTime(0).compareTo(MassageTimer.this.relayOnTime) == 1 || MassageTimer.addSecondToCurrentTime(0).compareTo(MassageTimer.this.relayOnTime) == 0) && MassageTimer.this.realyOn) {
                    MassageTimer.this.realyOn = false;
                    if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                        System.out.println("Leo Spa " + solarium_id + " Booked===Relay ON: " + MassageTimer.getCurrentTime(""));
                    }
                    if (solarium_id.equals("1")) {
                        SerialClient.turnRelaySwitch1_On();
                    } else if (solarium_id.equals("2")) {
                        SerialClient.turnRelaySwitch2_On();
                    } else if (solarium_id.equals("3")) {
                        SerialClient.turnRelaySwitch3_On();
                    } else if (solarium_id.equals("4")) {
                        SerialClient.turnRelaySwitch4_On();
                    }
                }
                if ((MassageTimer.addSecondToCurrentTime(0).compareTo(MassageTimer.this.relayOffTime) == 1 || MassageTimer.addSecondToCurrentTime(0).compareTo(MassageTimer.this.relayOffTime) == 0) && MassageTimer.this.realyOff) {
                    MassageTimer.this.realyOff = false;
                    if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                        System.out.println("Leo Spa " + solarium_id + " Booked===Relay OFF: " + MassageTimer.getCurrentTime(""));
                    }
                    if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                        System.out.println(System.getProperty("java.library.path"));
                    }
                    if (solarium_id.equals("1")) {
                        SerialClient.turnRelaySwitch1_Off();
                    } else if (solarium_id.equals("2")) {
                        SerialClient.turnRelaySwitch2_Off();
                    } else if (solarium_id.equals("3")) {
                        SerialClient.turnRelaySwitch3_Off();
                    } else if (solarium_id.equals("4")) {
                        SerialClient.turnRelaySwitch4_Off();
                    }
                }
                if ((MassageTimer.addSecondToCurrentTime(0).compareTo(MassageTimer.this.stopTimer) == 1 || MassageTimer.addSecondToCurrentTime(0).compareTo(MassageTimer.this.stopTimer) == 0) && MassageTimer.this.timerClose || max_time == 0) {
                    MassageTimer.this.timerClose = false;
                    if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                        System.out.println("Leo Spa " + solarium_id + " Timer Stop: " + MassageTimer.getCurrentTime(""));
                    }
                    Hashtable<String, String> massHash = Util.getUtilInstance().getMassageTimerHash();
                    massHash.remove(solarium_id);
                    MassageTimer.this.timer.stop();
                }
                if (MassageTimer.addSecondToCurrentTime(0).getSeconds() == MassageTimer.this.nextTime.getSeconds()) {
                    if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                        System.out.println(String.valueOf(solarium_id) + " Timer: " + MassageTimer.this.nextTime.toString());
                    }
                    MassageTimer.this.nextTime = new Time(MassageTimer.addSecondToCurrentTime(1).getTime());
                    --MassageTimer.this.count;
                }
            }
        });
        this.timer.start();
    }

    public int getTime() {
        return this.count;
    }

    public static String getCurrentTime(String msg) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        return sdf.format(cal.getTime());
    }

    public static String getCurrentTimeTest(int addSecond) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        calendar.add(13, addSecond);
        return sdf.format(calendar.getTime());
    }

    public static Date addSecondToCurrentTime(int addSecond) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        calendar.add(13, addSecond);
        return calendar.getTime();
    }

    public static Date getStringToDate(String actionTime) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date date = formatter.parse(actionTime);
        return date;
    }
}

